# GCG: Generic Column Generation
[![Conda Recipe](https://img.shields.io/badge/recipe-gcg-green.svg)](https://anaconda.org/conda-forge/gcg)
[![Conda Downloads](https://img.shields.io/conda/dn/conda-forge/gcg.svg)](https://anaconda.org/conda-forge/gcg)
[![Conda Version](https://img.shields.io/conda/vn/conda-forge/gcg.svg)](https://anaconda.org/conda-forge/gcg)
[![Conda Platforms](https://img.shields.io/conda/pn/conda-forge/gcg.svg)](https://anaconda.org/conda-forge/gcg)
[![Conda License](https://img.shields.io/conda/l/conda-forge/gcg.svg)](https://anaconda.org/conda-forge/gcg)

Welcome to what is currently one of the only available open-source solvers
for mixed integer programming (MIP) that applies a comprehensive and expandable Branch-Price-and-Cut framework. By making use of detection algorithms, GCG is able to apply Dantzig-Wolfe reformulation and Benders decomposition to solve (potentially) structured MIPs faster. It builds upon [SCIP](https://scipopt.org) and thus allows for total control of the solution process and the access of detailed information down to the guts of the
solver.

Further information and resources are available through the official website at
[gcg.or.rwth-aachen.de](https://gcg.or.rwth-aachen.de):

- [online documentation](https://gcg.or.rwth-aachen.de/doc) of the code with information on how to get started,
- [downloads](https://gcg.or.rwth-aachen.de/#download) of the released GCG source code versions,
- [papers](https://gcg.or.rwth-aachen.de/#related-work) that use GCG or explain algorithms implemented in GCG,
- information on how to [cite](https://gcg.or.rwth-aachen.de/#more) GCG when you use it in scientific publications,
- and much more!

For installation instructions have a look [here](doc/resources/installation/easy-install.md) or in the [online
documentation](https://gcg.or.rwth-aachen.de/doc/install.html).
