/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/*                                                                           */
/*                  This file is part of the program and library             */
/*          GCG --- Generic Column Generation                                */
/*                  a Dantzig-Wolfe decomposition based extension            */
/*                  of the branch-cut-and-price framework                    */
/*         SCIP --- Solving Constraint Integer Programs                      */
/*                                                                           */
/* Copyright (C) 2010-2026 Operations Research, RWTH Aachen University       */
/*                         Zuse Institute Berlin (ZIB)                       */
/*                                                                           */
/*  Licensed under the Apache License, Version 2.0 (the "License");          */
/*  you may not use this file except in compliance with the License.         */
/*  You may obtain a copy of the License at                                  */
/*                                                                           */
/*      http://www.apache.org/licenses/LICENSE-2.0                           */
/*                                                                           */
/*  Unless required by applicable law or agreed to in writing, software      */
/*  distributed under the License is distributed on an "AS IS" BASIS,        */
/*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. */
/*  See the License for the specific language governing permissions and      */
/*  limitations under the License.                                           */
/*                                                                           */
/*  You should have received a copy of the Apache-2.0 license                */
/*  along with GCG; see the file LICENSE. If not visit gcg.or.rwth-aachen.de.*/
/*                                                                           */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/**@file        event_mastersepacut.h
 * @ingroup     EVENTS
 * @brief       event handler which manages the active master separator cuts
 * @author      Chantal Reinartz Groba
 */

/*---+----1----+----2----+----3----+----4----+----5----+----6----+----7----+----8----+----9----+----0----+----1----+----2*/

#ifndef __SCIP_EVENT_MASTERSEPACUTS_H__
#define __SCIP_EVENT_MASTERSEPACUTS_H__


#include <scip/scip.h>

#include "gcg/gcg.h"

#ifdef __cplusplus
extern "C" {
#endif


/** creates event handler for managing the additional data of the mastercuts generated by master separators */
GCG_EXPORT
SCIP_RETCODE GCGincludeEventHdlrSepaCuts(
   GCG*              gcg            /**< GCG data structure */
   );

/** removes the mastersepacuts which were applied at current node, but have already been removed from the LP */
SCIP_RETCODE GCGeventmastersepacutRemoveNewInactiveMastersepacuts(
   GCG*              gcg,           /**< GCG data structure */
   SCIP_EVENTHDLR*   eventhdlr,     /**< mastersepacut event handler */
   int               startidx       /**< indicate the first new mastersepacut */
   );

/** removes all mastersepacuts after given index from active cuts */
SCIP_RETCODE GCGeventmastersepacutShrinkActiveMastersepacuts(
   GCG*              gcg,             /**< GCG data structure */
   SCIP_EVENTHDLR*   eventhdlr,       /**< mastersepacuts event handler */
   int               newnrows         /**< index to which active cuts should be shrunk to */
   );

/** adds a mastercut generated by a master separator to active cuts */
SCIP_RETCODE GCGeventmastersepacutAddActiveMastersepacut(
   GCG*                          gcg,              /**< GCG data structure */
   SCIP_EVENTHDLR*               eventhdlr,        /**< mastersepacut event handler */
   GCG_EXTENDEDMASTERCONSDATA*   mastersepacut     /**< mastersepacut */
   );

/** return number of active master separator cuts */
int GCGeventmastersepacutGetNActiveMastersepacuts(
   GCG*              gcg,            /**< GCG data structure */
   SCIP_EVENTHDLR*   eventhdlr       /**< masterepacut event handler */
   );

/** returns active master separator cuts */
GCG_EXTENDEDMASTERCONSDATA** GCGeventmastersepacutGetActiveMastersepacuts(
   GCG*              gcg,            /**< GCG data structure */
   SCIP_EVENTHDLR*   eventhdlr       /**< mastersepacut event handler*/
   );

#ifdef __cplusplus
}
#endif

#endif
